require( "scripts/style.lua" )
require( "scripts/chocshopstyle.lua" )

TableInfoFont = {
  edwardian_medium,
  17,
  WhiteColor
};

MakeDialog
{
	name = "hiscoreinfo",
	
	RBounceWindow 
	{
	    x = 250, 
	    y = -1000,
	    w = 300,
	    h = 400,
	    targetposx = 250, 
	    targetposy = 100,
	    bouncelen = 200, 
	    bouncefunc = "sincx",
	    
		KSplit9Image
		{ 
			image = "ui/backgrounds/split9_dialog_small",	
			x = kCenter,
			y = kCenter,
			w = 300,
			h = 400,
			x1 = 18,
			y1 = 18,
			x2 = 18,
			y2 = 18,

			Text
			{
				font = TableInfoFont,
				name = "info",
				x=14,y=18,w=kMax - 18,h=kMax - 75,
				flags = kHAlignCenter + kVAlignTop,
				label = "scores_highscorecompleteinfo"
			};
			
			SetStyle( CSOvalGreenButtonStyle ),
			Button
			{
				x			= kCenter,
				y			= 320,
				label		= "app_ok",
				name		= "ok",
				default		= true,
				command		=
					function()
					    DoTransition( kBounceBack );
					    PopModal( 'hiscoreinfo' );
					end
			},
			
			Button
			{
				x=0,
				y=0,
				w=0,
				h=0,
				graphics={},
				name="privacypolicy",
				command = 
					function()
						LaunchPrivacyPolicy();
					end
			};
		},
	},
}